CREATE DATABASE painel_tizen;


USE painel_tizen;


-- Usuários admins
CREATE TABLE users (
id INT AUTO_INCREMENT PRIMARY KEY,
username VARCHAR(50) UNIQUE NOT NULL,
password VARCHAR(255) NOT NULL
);


-- Dispositivos
CREATE TABLE devices (
id INT AUTO_INCREMENT PRIMARY KEY,
mac VARCHAR(50) NOT NULL,
device_id VARCHAR(100) NOT NULL,
status ENUM('teste','ativo','expirado') DEFAULT 'teste',
data_criacao DATETIME DEFAULT CURRENT_TIMESTAMP,
data_expiracao DATETIME
);


-- Pagamentos
CREATE TABLE payments (
id INT AUTO_INCREMENT PRIMARY KEY,
device_ref INT NOT NULL,
valor DECIMAL(10,2) NOT NULL,
data_pagamento DATETIME DEFAULT CURRENT_TIMESTAMP,
FOREIGN KEY (device_ref) REFERENCES devices(id)
);