<?php
include 'db.php';
header('Content-Type: application/json');


// suporta GET e POST
$mac = $_REQUEST['mac'] ?? '';
$device_id = $_REQUEST['device_id'] ?? '';


if(!$mac || !$device_id){
echo json_encode(['status'=>'erro','mensagem'=>'MAC ou Device ID faltando']);
exit;
}


// sanitize
$mac = trim($mac);
$device_id = trim($device_id);


$stmt = $pdo->prepare("SELECT * FROM devices WHERE mac=? AND device_id=?");
$stmt->execute([$mac, $device_id]);
$device = $stmt->fetch();


if($device){
$hoje = new DateTime('now');
$expira = $device['data_expiracao'] ? new DateTime($device['data_expiracao']) : null;


// atualiza status automático se expirou
if($device['status'] == 'teste' && $expira && $hoje > $expira){
$pdo->prepare("UPDATE devices SET status='expirado' WHERE id=?")->execute([$device['id']]);
echo json_encode(['status'=>'bloqueado','mensagem'=>'Teste expirado']);
exit;
}


if($device['status'] == 'ativo'){
echo json_encode(['status'=>'ativo','mensagem'=>'Acesso liberado']);
} elseif($device['status'] == 'teste'){
echo json_encode(['status'=>'teste','mensagem'=>'Período de teste ativo','dias_restantes' => max(0, (int)($expira->getTimestamp() - $hoje->getTimestamp())/86400)]);
} else {
echo json_encode(['status'=>'bloqueado','mensagem'=>'Dispositivo expirado ou bloqueado']);
}


} else {
echo json_encode(['status'=>'nao_registrado','mensagem'=>'Dispositivo não encontrado']);
}