<?php
// index.php - Painel FR PLAY (UI)
// Apenas frontend que consome api/login.php
?>
<!doctype html>
<html lang="pt-BR">
<head>
  <meta charset="utf-8" />
  <title>Painel FR PLAY</title>
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <link rel="stylesheet" href="css/style.css">
</head>
<body>
  <main class="panel">
    <header>
      <h1>FR <span>PLAY</span> — Painel</h1>
      <p class="subtitle">Ativação por MAC • Trial 7 dias • Ativado = 1 ano</p>
    </header>

    <section class="card">
      <h2>Checar / Criar Trial</h2>
      <div class="form-row">
        <label>MAC (ex: AA:BB:CC:DD:EE:FF)</label>
        <input id="macInput" type="text" placeholder="Digite o MAC" />
      </div>
      <div class="form-row">
        <label>Device (opcional)</label>
        <input id="deviceInput" type="text" placeholder="Nome do dispositivo" />
      </div>
      <div class="actions">
        <button id="checkBtn" class="btn primary">Checar / Criar Trial</button>
      </div>
      <pre id="checkResult" class="result"></pre>
    </section>

    <section class="card">
      <h2>Admin — Ativar / Gerenciar</h2>
      <div class="form-row">
        <label>Admin Key</label>
        <input id="adminKey" type="password" placeholder="Chave do painel (troque em api/login.php)" />
      </div>

      <div style="display:flex;gap:12px;flex-wrap:wrap;margin-top:10px;">
        <div style="flex:1;min-width:260px;">
          <div class="form-row">
            <label>MAC</label>
            <input id="macActivate" type="text" placeholder="MAC à ativar" />
          </div>
          <div class="form-row">
            <label>M3U URL</label>
            <input id="m3uUrl" type="text" placeholder="URL M3U para este usuário" />
          </div>
          <div class="actions">
            <button id="activateBtn" class="btn red">Ativar 1 Ano</button>
          </div>
          <pre id="activateResult" class="result"></pre>
        </div>

        <div style="flex:1;min-width:260px;">
          <h3 class="small">Trocar MAC (preserva validade)</h3>
          <div class="form-row">
            <label>MAC antigo</label>
            <input id="oldMac" type="text" placeholder="MAC atual do usuário" />
          </div>
          <div class="form-row">
            <label>Novo MAC</label>
            <input id="newMac" type="text" placeholder="Novo MAC a atribuir" />
          </div>
          <div class="actions">
            <button id="swapBtn" class="btn primary">Trocar MAC mantendo validade</button>
          </div>
          <pre id="swapResult" class="result"></pre>
        </div>
      </div>
    </section>

    <section class="card">
      <h2>Lista de devices (admin)</h2>
      <div style="display:flex;gap:8px;margin-bottom:8px;">
        <input id="listAdminKey" type="password" placeholder="Admin Key para listar" style="flex:1;padding:10px;border-radius:8px;">
        <button id="listBtn" class="btn">Listar</button>
      </div>
      <div id="listResult" class="result"></div>
    </section>

    <footer class="footer">
      FR PLAY • Painel Simples • Ajuste o admin_key em api/login.php
    </footer>
  </main>

<script>
const API = 'api/login.php';

// Check / create trial
document.getElementById('checkBtn').addEventListener('click', () => {
  const mac = document.getElementById('macInput').value.trim();
  const device = document.getElementById('deviceInput').value.trim();
  if (!mac) { alert('Digite um MAC'); return; }
  fetch(${API}?mac=${encodeURIComponent(mac)}&device=${encodeURIComponent(device)})
    .then(r => r.json())
    .then(j => { document.getElementById('checkResult').textContent = JSON.stringify(j, null, 2); })
    .catch(e => { document.getElementById('checkResult').textContent = 'Erro: ' + e; });
});

// Activate (admin)
document.getElementById('activateBtn').addEventListener('click', () => {
  const admin_key = document.getElementById('adminKey').value.trim();
  const mac = document.getElementById('macActivate').value.trim();
  const m3u = document.getElementById('m3uUrl').value.trim();
  if (!admin_key || !mac) { alert('Admin key e MAC são obrigatórios'); return; }
  const form = new FormData();
  form.append('action','activate');
  form.append('admin_key', admin_key);
  form.append('mac', mac);
  form.append('device', '');
  form.append('m3u_url', m3u);
  fetch(API, { method: 'POST', body: form })
    .then(r => r.json())
    .then(j => { document.getElementById('activateResult').textContent = JSON.stringify(j, null, 2); })
    .catch(e => { document.getElementById('activateResult').textContent = 'Erro: ' + e; });
});

// Swap MAC (admin)
document.getElementById('swapBtn').addEventListener('click', () => {
  const admin_key = document.getElementById('adminKey').value.trim();
  const oldMac = document.getElementById('oldMac').value.trim();
  const newMac = document.getElementById('newMac').value.trim();
  if (!admin_key || !oldMac || !newMac) { alert('Admin key, oldMac e newMac são obrigatórios'); return; }
  const form = new FormData();
  form.append('action','swap_mac');
  form.append('admin_key', admin_key);
  form.append('old_mac', oldMac);
  form.append('new_mac', newMac);
  fetch(API, { method:'POST', body: form })
    .then(r => r.json())
    .then(j => { document.getElementById('swapResult').textContent = JSON.stringify(j, null, 2); })
    .catch(e => { document.getElementById('swapResult').textContent = 'Erro: ' + e; });
});

// List devices (admin)
document.getElementById('listBtn').addEventListener('click', () => {
  const admin_key = document.getElementById('listAdminKey').value.trim();
  if (!admin_key) { alert('Admin key obrigatório'); return; }
  const form = new FormData();
  form.append('action','list');
  form.append('admin_key', admin_key);
  fetch(API, { method:'POST', body: form })
    .then(r => r.json())
    .then(j => {
      if (j.status === 'ok') {
        const arr = j.devices || [];
        let html = '<table class="table"><thead><tr><th>MAC</th><th>Device</th><th>Expire</th><th>Trial</th><th>Notas</th></tr></thead><tbody>';
        arr.forEach(d => {
          html += <tr><td>${d.mac}</td><td>${d.device||''}</td><td>${d.expire||''}</td><td>${d.trial? 'SIM' : 'NÃO'}</td><td>${d.notes||''}</td></tr>;
        });
        html += '</tbody></table>';
        document.getElementById('listResult').innerHTML = html;
      } else {
        document.getElementById('listResult').textContent = JSON.stringify(j, null, 2);
      }
    })
    .catch(e => { document.getElementById('listResult').textContent = 'Erro: ' + e; });
});
</script>

</body>
</html>