<?php
$pdo->prepare("DELETE FROM devices WHERE id=?")->execute([$id]);
header('Location: dashboard.php');
exit;
}


// Listar dispositivos
$devices = $pdo->query("SELECT * FROM devices ORDER BY data_criacao DESC")->fetchAll();


?>


<!doctype html>
<html>
<head>
<meta charset="utf-8">
<title>Dashboard - Painel Tizen</title>
<link rel="stylesheet" href="css/style.css">
</head>
<body>
<div class="container">
<h1>Painel Admin</h1>
<p><a href="logout.php">Sair</a></p>


<div class="card">
<h3>Adicionar dispositivo (manual)</h3>
<form method="POST">
<input type="text" name="mac" placeholder="MAC" required>
<input type="text" name="device_id" placeholder="Device ID" required>
<button type="submit" name="add_device">Adicionar Dispositivo</button>
</form>
</div>


<div class="card">
<h3>Dispositivos</h3>
<table class="table">
<thead>
<tr>
<th>ID</th>
<th>MAC</th>
<th>Device ID</th>
<th>Status</th>
<th>Data Expiração</th>
<th>Ações</th>
</tr>
</thead>
<tbody>
<?php foreach($devices as $d): ?>
<tr>
<td><?= $d['id'] ?></td>
<td><?= esc($d['mac']) ?></td>
<td><?= esc($d['device_id']) ?></td>
<td><?= $d['status'] ?></td>
<td><?= $d['data_expiracao'] ?></td>
<td>
<a href="?activate=<?= $d['id'] ?>">Ativar</a> |
<a href="?expire=<?= $d['id'] ?>">Expirar</a> |
<a href="?delete=<?= $d['id'] ?>" onclick="return confirm('Remover dispositivo?')">Remover</a>
</td>
</tr>
<?php endforeach; ?>
</tbody>
</table>
</div>


</div>
</body>
</html>