CREATE DATABASE frplay CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
USE frplay;

CREATE TABLE devices (
  id INT AUTO_INCREMENT PRIMARY KEY,
  mac VARCHAR(32) UNIQUE NOT NULL,
  device VARCHAR(128),
  m3u_url TEXT,
  activated_at DATETIME,
  expire_at DATETIME,
  trial TINYINT(1) DEFAULT 0,
  status ENUM('trial','active','expired') DEFAULT 'trial',
  notes TEXT,
  reseller_id INT DEFAULT NULL,
  last_check_at DATETIME DEFAULT NULL
);

CREATE TABLE logs (
  id INT AUTO_INCREMENT PRIMARY KEY,
  mac VARCHAR(32),
  action VARCHAR(64),
  ip VARCHAR(64),
  timestamp DATETIME,
  message TEXT
);