<?php
// api/config.php
date_default_timezone_set('UTC');

// === CONFIGURAÇÃO BANCO DE DADOS ===
$DB_HOST = 'localhost';
$DB_NAME = 'frplay';
$DB_USER = 'root';
$DB_PASS = 'sua_senha_aqui';

// === CHAVE ADMIN (para API / Painel) ===
$ADMIN_KEY = 'troque_este_admin_key';

// === CONFIGURAÇÕES GERAIS DO SISTEMA ===
define('ADMIN_USER', 'admin');
define('ADMIN_PASS', '123456');
define('TRIAL_DAYS', 7);      // dias de teste grátis
define('RENEW_DAYS', 365);    // dias de renovação após pagamento

// === CONEXÃO PDO ===
try {
  $pdo = new PDO("mysql:host=$DB_HOST;dbname=$DB_NAME;charset=utf8mb4", $DB_USER, $DB_PASS, [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
  ]);
} catch (Exception $e) {
  die('Erro conexão: '.$e->getMessage());
}

// === FUNÇÃO GLOBAL DE LOG ===
function add_log($pdo, $mac, $action, $msg) {
  $ip = $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0';
  $stmt = $pdo->prepare("INSERT INTO logs (mac, action, ip, timestamp, message) VALUES (?, ?, ?, NOW(), ?)");
  $stmt->execute([$mac, $action, $ip, $msg]);
}