<?php
require_once 'config.php';
session_start();
if(!isset($_SESSION['user_id'])){
    header("Location: login.php");
    exit;
}

$transactions = $pdo->query("
    SELECT t.*, u.username as user_name 
    FROM transactions t 
    LEFT JOIN users u ON t.user_id = u.id
    ORDER BY t.id DESC
")->fetchAll();

$page_content = '
<div class="container">
<h2>Transações</h2>
<table>
<tr><th>ID</th><th>Usuário</th><th>Tipo</th><th>Valor</th><th>Nota</th><th>Data</th></tr>';
foreach($transactions as $t){
    $page_content.='<tr>
<td>'.$t['id'].'</td>
<td>'.$t['user_name'].'</td>
<td>'.$t['type'].'</td>
<td>'.$t['amount'].'</td>
<td>'.$t['note'].'</td>
<td>'.$t['created_at'].'</td>
</tr>';
}
$page_content.='</table></div>';

include 'base.php';
