<?php
require_once 'config.php';
session_start();
if(!isset($_SESSION['user_id']) || $_SESSION['role']!=='admin'){
    header("Location: login.php");
    exit;
}

$message = '';
if($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['add_user'])){
    $username = trim($_POST['username']);
    $password = $_POST['password'];
    $name = $_POST['name'];
    $email = $_POST['email'];
    $credits = (int)$_POST['credits'];
    if($username && $password){
        $stmt = $pdo->prepare("INSERT INTO users (username,password_hash,role,name,email,credits) VALUES (:username,:hash,'revendedor',:name,:email,:credits)");
        $stmt->execute([
            ':username'=>$username,
            ':hash'=>hash_password($password),
            ':name'=>$name,
            ':email'=>$email,
            ':credits'=>$credits
        ]);
        $message = "Revendedor criado com sucesso!";
    } else {
        $message = "Usuário e senha são obrigatórios.";
    }
}

$stmt = $pdo->query("SELECT * FROM users WHERE role='revendedor' ORDER BY id DESC");
$revendedores = $stmt->fetchAll();

$page_content = '
<div class="container">
'.($message?'<div class="message">'.$message.'</div>':'').'
<h2>Adicionar Revendedor</h2>
<form method="POST">
<input type="text" name="username" placeholder="Usuário" required>
<input type="password" name="password" placeholder="Senha" required>
<input type="text" name="name" placeholder="Nome">
<input type="email" name="email" placeholder="Email">
<input type="number" name="credits" placeholder="Créditos iniciais" value="0">
<button type="submit" name="add_user">Criar Revendedor</button>
</form>

<h2>Revendedores Existentes</h2>
<table>
<tr><th>ID</th><th>Usuário</th><th>Nome</th><th>Email</th><th>Créditos</th></tr>';
foreach($revendedores as $r){
    $page_content.='<tr>
<td>'.$r['id'].'</td>
<td>'.$r['username'].'</td>
<td>'.$r['name'].'</td>
<td>'.$r['email'].'</td>
<td>'.$r['credits'].'</td>
</tr>';
}
$page_content.='</table>
</div>';

include 'base.php';
