<?php
require_once 'config.php';
session_start();
if(!isset($_SESSION['user_id'])){
    header("Location: login.php");
    exit;
}

$message = '';
if($_SERVER['REQUEST_METHOD']==='POST'){
    $macRaw = trim($_POST['mac']);
    $days = (int)($_POST['days'] ?? 365);
    $cost = (int)($_POST['credits'] ?? 0);

    $mac = preg_replace('/[^A-Fa-f0-9]/', '', $mac);
    $mac = strtoupper(implode(':', str_split($mac,2)));

    $stmt = $pdo->prepare("SELECT * FROM devices WHERE mac=:mac LIMIT 1");
    $stmt->execute([':mac'=>$mac]);
    $device = $stmt->fetch();

    if(!$device){
        $message = "MAC não encontrado!";
    } else {
        $stmt2 = $pdo->prepare("SELECT credits FROM users WHERE id=:id LIMIT 1");
        $stmt2->execute([':id'=>$_SESSION['user_id']]);
        $userCredits = (int)$stmt2->fetchColumn();

        if($userCredits < $cost){
            $message = "Créditos insuficientes!";
        } else {
            $pdo->prepare("UPDATE devices SET expires_at=DATE_ADD(NOW(), INTERVAL :days DAY), status='active' WHERE id=:id")
                ->execute([':days'=>$days,':id'=>$device['id']]);
            $pdo->prepare("UPDATE users SET credits=credits-:cost WHERE id=:id")->execute([':cost'=>$cost,':id'=>$_SESSION['user_id']]);
            $pdo->prepare("INSERT INTO transactions (user_id,type,amount,note,created_at) VALUES (:user_id,'credit_use',:amount,:note,NOW())")
                ->execute([':user_id'=>$_SESSION['user_id'],':amount'=>$cost,':note'=>"Validade $days dias para MAC $mac"]);
            $message = "Validade estendida com sucesso!";
        }
    }
}

$devices = $pdo->query("SELECT * FROM devices ORDER BY id DESC")->fetchAll();

$page_content = '
<div class="container">
'.($message?'<div class="message">'.$message.'</div>':'').'
<h2>Extender validade usando créditos</h2>
<form method="POST">
<select name="mac" required>
<option value="">Escolha um MAC</option>';
foreach($devices as $d){
    $page_content.='<option value="'.$d['mac'].'">'.$d['mac'].' - Status: '.$d['status'].'</option>';
}
$page_content.='</select>
<input type="number" name="credits" placeholder="Créditos a usar" required>
<input type="number" name="days" placeholder="Dias de validade (padrão 365)">
<button type="submit">Resgatar</button>
</form>
</div>';

include 'base.php';
