<?php
require_once 'config.php';
session_start();
if(isset($_SESSION['user_id'])){
    header("Location: dashboard.php");
    exit;
}

$message = '';
if($_SERVER['REQUEST_METHOD']==='POST'){
    $username = trim($_POST['username']);
    $password = $_POST['password'];

    $stmt = $pdo->prepare("SELECT * FROM users WHERE username = :username LIMIT 1");
    $stmt->execute([':username'=>$username]);
    $user = $stmt->fetch();

    if($user && verify_password($password, $user['password_hash'])){
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['role'] = $user['role'];
        $_SESSION['username'] = $user['username'];
        $pdo->prepare("UPDATE users SET last_login=NOW() WHERE id=:id")->execute([':id'=>$user['id']]);
        header("Location: dashboard.php");
        exit;
    } else {
        $message = "Usuário ou senha incorretos.";
    }
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
<meta charset="UTF-8">
<title><?php echo APP_NAME;?> - Login</title>
<style>
body{margin:0;font-family:Inter,Segoe UI,Roboto,Arial;background:#0b0b0b;color:#fff;display:flex;align-items:center;justify-content:center;height:100vh;}
.login-container{background:#1c1c1c;padding:30px;border-radius:12px;width:360px;box-shadow:0 6px 20px rgba(193,18,31,0.3);}
h1{color:#c1121f;text-align:center;margin-bottom:24px;}
input[type=text],input[type=password]{width:100%;padding:12px;margin:8px 0;border-radius:8px;border:none;background:#0b0b0b;color:#fff;}
button{width:100%;padding:12px;background:#c1121f;border:none;color:#fff;font-weight:bold;border-radius:8px;cursor:pointer;}
button:hover{background:#a00f1a;}
.message{color:#c1121f;text-align:center;margin-bottom:8px;}
</style>
</head>
<body>
<div class="login-container">
<h1><?php echo APP_NAME;?></h1>
<?php if($message):?><div class="message"><?php echo $message;?></div><?php endif;?>
<form method="POST">
<input type="text" name="username" placeholder="Usuário" required>
<input type="password" name="password" placeholder="Senha" required>
<button type="submit">Entrar</button>
</form>
</div>
</body>
</html>
