-- Criação do banco (caso não exista)
CREATE DATABASE IF NOT EXISTS ziten CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;
USE ziten;

-- ======================================
-- 1️⃣ Tabela: users
-- Admin, revendedores e usuários
-- ======================================
CREATE TABLE IF NOT EXISTS users (
    id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) NOT NULL UNIQUE,
    password_hash VARCHAR(255) NOT NULL,
    role ENUM('admin','revendedor','user') NOT NULL DEFAULT 'user',
    name VARCHAR(100),
    email VARCHAR(100),
    credits INT UNSIGNED DEFAULT 0,
    last_login DATETIME DEFAULT NULL,
    created_at DATETIME DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ======================================
-- 2️⃣ Tabela: devices
-- Dispositivos / MACs
-- ======================================
CREATE TABLE IF NOT EXISTS devices (
    id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    mac VARCHAR(17) NOT NULL UNIQUE,
    status ENUM('active','blocked') NOT NULL DEFAULT 'active',
    expires_at DATETIME NOT NULL,
    created_at DATETIME DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ======================================
-- 3️⃣ Tabela: accounts
-- Contas M3U
-- ======================================
CREATE TABLE IF NOT EXISTS accounts (
    id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) NOT NULL UNIQUE,
    password VARCHAR(50) NOT NULL,
    m3u TEXT NOT NULL,
    status ENUM('active','inactive') DEFAULT 'active',
    created_at DATETIME DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ======================================
-- 4️⃣ Tabela: transactions
-- Histórico de créditos e compras
-- ======================================
CREATE TABLE IF NOT EXISTS transactions (
    id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    user_id INT UNSIGNED NOT NULL,
    type ENUM('credit_add','credit_use') NOT NULL,
    amount INT UNSIGNED NOT NULL,
    note VARCHAR(255),
    created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ======================================
-- 5️⃣ Inserir admin inicial
-- ======================================
INSERT INTO users (username, password_hash, role, name, email, credits)
VALUES ('admin','" . password_hash("admin123", PASSWORD_DEFAULT) . "','admin','Admin','admin@ziten.com',1000);
