<?php
require_once 'config.php';
session_start();
if(!isset($_SESSION['user_id'])){
    header("Location: login.php");
    exit;
}

$message = '';
if(isset($_GET['block_id'])){
    $pdo->prepare("UPDATE devices SET status='blocked' WHERE id=:id")->execute([':id'=>$_GET['block_id']]);
}
if(isset($_GET['unblock_id'])){
    $pdo->prepare("UPDATE devices SET status='active' WHERE id=:id")->execute([':id'=>$_GET['unblock_id']]);
}
if($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['extend_id'])){
    $days = (int)$_POST['days'];
    $pdo->prepare("UPDATE devices SET expires_at=DATE_ADD(NOW(), INTERVAL :days DAY), status='active' WHERE id=:id")
        ->execute([':days'=>$days,':id'=>$_POST['extend_id']]);
    $message = "Validade estendida com sucesso!";
}

$devices = $pdo->query("SELECT * FROM devices ORDER BY id DESC")->fetchAll();

$page_content = '
<div class="container">
'.($message?'<div class="message">'.$message.'</div>':'').'
<h2>Devices</h2>
<table>
<tr><th>ID</th><th>MAC</th><th>Status</th><th>Expira</th><th>Ações</th></tr>';
foreach($devices as $d){
    $page_content.='<tr>
<td>'.$d['id'].'</td>
<td>'.$d['mac'].'</td>
<td>'.$d['status'].'</td>
<td>'.$d['expires_at'].'</td>
<td>';
    if($d['status']=='active'){
        $page_content.='<a href="?block_id='.$d['id'].'"><button>Bloquear</button></a>';
    } else {
        $page_content.='<a href="?unblock_id='.$d['id'].'"><button>Desbloquear</button></a>';
    }
    $page_content.='<form method="POST" style="display:inline;">
    <input type="hidden" name="extend_id" value="'.$d['id'].'">
    <input type="number" name="days" placeholder="Dias" style="width:60px;" required>
    <button type="submit">Estender</button>
    </form></td>
</tr>';
}
$page_content.='</table></div>';

include 'base.php';
