<?php
// config.php
// Configuração principal do painel IPTV (FR PLAY / estilo Vizzion)

// ⚙️ CONFIGURAÇÃO DO BANCO DE DADOS
$DB_HOST = "localhost";        // geralmente localhost
$DB_NAME = "rrtvstor_play_fr";       // mesmo nome criado no MySQL
$DB_USER = "rrtvstor_rrtvstor_play_fr";             // seu usuário MySQL (ajuste)
$DB_PASS = "2Z6FIc.A7NL~SnH(";                 // sua senha MySQL

try {
    // Cria conexão PDO segura
    $pdo = new PDO(
        "mysql:host={$DB_HOST};dbname={$DB_NAME};charset=utf8mb4",
        $DB_USER,
        $DB_PASS,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false,
        ]
    );
} catch (PDOException $e) {
    die(json_encode([
        'status' => 'error',
        'message' => 'Erro ao conectar ao banco: ' . $e->getMessage()
    ]));
}

// 🌐 URL padrão da M3U (ajuste para sua lista)
define('DEFAULT_M3U_URL', 'https://seuservidor.com/m3u/default.m3u');

// 🧱 Configurações gerais
define('APP_NAME', 'FR Play Panel');
define('APP_VERSION', '1.0.0');
define('TRIAL_DAYS', 7); // Duração do teste grátis
define('ANNUAL_DAYS', 365); // Duração após pagamento
define('TIMEZONE', 'America/Sao_Paulo');

date_default_timezone_set(TIMEZONE);

// Função utilitária para gerar resposta JSON padrão
function json_response($data, $status = 200)
{
    http_response_code($status);
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode($data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    exit;
}

// Função para hashing e validação de senha (para login no painel)
function hash_password($password) {
    return password_hash($password, PASSWORD_DEFAULT);
}

function verify_password($password, $hash) {
    return password_verify($password, $hash);
}
