<?php
require_once 'config.php';
header('Content-Type: application/json');

$mac = $_POST['mac'] ?? '';
if(!$mac){
    echo json_encode(['error'=>'MAC obrigatório']);
    exit;
}

$macClean = preg_replace('/[^A-Fa-f0-9]/', '', $mac);
$macClean = strtoupper(implode(':', str_split($macClean,2)));

$stmt = $pdo->prepare("SELECT d.*, a.m3u FROM devices d LEFT JOIN accounts a ON d.mac=a.username WHERE d.mac=:mac LIMIT 1");
$stmt->execute([':mac'=>$macClean]);
$device = $stmt->fetch();

if(!$device){
    echo json_encode(['error'=>'MAC não encontrado']);
} else {
    $daysLeft = (strtotime($device['expires_at']) - time())/86400;
    echo json_encode([
        'mac'=>$device['mac'],
        'status'=>$device['status'],
        'days_left'=>max(0,round($daysLeft)),
        'm3u'=>$device['m3u'] ?? ''
    ]);
}
