<?php
// base.php
session_start();
if(!isset($_SESSION['user_id'])){
    header("Location: login.php");
    exit;
}

$current_page = basename($_SERVER['PHP_SELF']);
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
<meta charset="UTF-8">
<title><?php echo APP_NAME;?></title>
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600&display=swap" rel="stylesheet">
<style>
:root{
    --bg-black:#0b0b0b;
    --bg-dark:#1c1c1c;
    --primary-red:#c1121f;
    --white:#fff;
}
body{margin:0;font-family:Inter,Segoe UI,Roboto,Arial;background:var(--bg-black);color:var(--white);}
header{height:60px;background:var(--bg-dark);display:flex;align-items:center;justify-content:space-between;padding:0 20px;box-shadow:0 4px 15px rgba(0,0,0,0.5);}
header h1{color:var(--primary-red);margin:0;font-size:20px;}
header a.logout{color:var(--white);background:var(--primary-red);padding:6px 12px;border-radius:6px;text-decoration:none;}
.container{display:flex;}
nav{width:220px;background:linear-gradient(145deg,var(--bg-dark),#111);height:calc(100vh - 60px);padding-top:20px;position:fixed;top:60px;left:0;}
nav a{display:block;color:var(--white);padding:12px 20px;margin:4px 0;text-decoration:none;border-radius:8px;}
nav a.active, nav a:hover{background:var(--primary-red);}
main{margin-left:220px;padding:20px;flex:1;min-height:calc(100vh - 60px);background:radial-gradient(circle at top left,#0b0b0b,#1c0a0a);}
.card{background:var(--bg-dark);border-radius:12px;padding:20px;margin-bottom:20px;box-shadow:0 6px 20px rgba(193,18,31,0.4);}
.card h2{color:var(--primary-red);margin:0 0 10px 0;}
.card p{font-size:28px;margin:0;}
table{width:100%;border-collapse:collapse;margin-top:20px;}
th,td{padding:12px;border-bottom:1px solid rgba(255,255,255,0.05);}
th{color:var(--primary-red);}
button{background:var(--primary-red);color:var(--white);padding:6px 12px;border:none;border-radius:6px;cursor:pointer;}
button:hover{background:#a00f1a;}
input, select{padding:10px;border-radius:6px;border:none;background:#0b0b0b;color:#fff;width:100%;margin:6px 0;}
.message{color:var(--primary-red);margin-bottom:10px;}
</style>
</head>
<body>
<header>
<h1><?php echo APP_NAME;?></h1>
<a href="logout.php" class="logout">Sair</a>
</header>
<div class="container">
<nav>
<a href="dashboard.php" <?php if($current_page=='dashboard.php') echo 'class="active"';?>>Dashboard</a>
<a href="revendedores.php" <?php if($current_page=='revendedores.php') echo 'class="active"';?>>Revendedores</a>
<a href="accounts.php" <?php if($current_page=='accounts.php') echo 'class="active"';?>>Contas</a>
<a href="devices.php" <?php if($current_page=='devices.php') echo 'class="active"';?>>Devices</a>
<a href="transactions.php" <?php if($current_page=='transactions.php') echo 'class="active"';?>>Transações</a>
<a href="redeem_credit.php" <?php if($current_page=='redeem_credit.php') echo 'class="active"';?>>Resgatar Créditos</a>
</nav>
<main>
<?php
if(isset($page_content)){
    echo $page_content;
}
?>
</main>
</div>
</body>
</html>
