<?php
require_once 'config.php';
header('Content-Type: application/json');

$mac = $_POST['mac'] ?? '';
if(!$mac){
    echo json_encode(['error'=>'MAC obrigatório']);
    exit;
}

$macClean = preg_replace('/[^A-Fa-f0-9]/', '', $mac);
$macClean = strtoupper(implode(':', str_split($macClean,2)));

$stmt = $pdo->prepare("SELECT * FROM devices WHERE mac=:mac LIMIT 1");
$stmt->execute([':mac'=>$macClean]);
$device = $stmt->fetch();

if(!$device){
    // Criar device com trial 7 dias
    $pdo->prepare("INSERT INTO devices (mac,status,expires_at) VALUES (:mac,'active',DATE_ADD(NOW(), INTERVAL 7 DAY))")
        ->execute([':mac'=>$macClean]);
    echo json_encode(['status'=>'active','trial_days'=>7]);
} else {
    $daysLeft = (strtotime($device['expires_at']) - time())/86400;
    echo json_encode(['status'=>$device['status'],'days_left'=>max(0,round($daysLeft))]);
}
