<?php
require_once 'config.php';
session_start();
if(!isset($_SESSION['user_id'])){
    header("Location: login.php");
    exit;
}

$message = '';
// Adicionar conta M3U
if($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['add_account'])){
    $username = trim($_POST['username']);
    $password = $_POST['password'];
    $m3u = trim($_POST['m3u']);
    $status = 'active';

    if($username && $password && $m3u){
        $stmt = $pdo->prepare("INSERT INTO accounts (username,password,m3u,status) VALUES (:username,:password,:m3u,:status)");
        $stmt->execute([
            ':username'=>$username,
            ':password'=>$password,
            ':m3u'=>$m3u,
            ':status'=>$status
        ]);
        $message = "Conta criada com sucesso!";
    } else {
        $message = "Todos os campos são obrigatórios.";
    }
}

// Listar contas
$accounts = $pdo->query("SELECT * FROM accounts ORDER BY id DESC")->fetchAll();

$page_content = '
<div class="container">
'.($message?'<div class="message">'.$message.'</div>':'').'
<h2>Adicionar Conta M3U</h2>
<form method="POST">
<input type="text" name="username" placeholder="Usuário" required>
<input type="password" name="password" placeholder="Senha" required>
<input type="text" name="m3u" placeholder="URL M3U" required>
<button type="submit" name="add_account">Adicionar</button>
</form>

<h2>Contas Existentes</h2>
<table>
<tr><th>ID</th><th>Usuário</th><th>M3U</th><th>Status</th></tr>';
foreach($accounts as $a){
    $page_content.='<tr>
<td>'.$a['id'].'</td>
<td>'.$a['username'].'</td>
<td>'.$a['m3u'].'</td>
<td>'.$a['status'].'</td>
</tr>';
}
$page_content.='</table>
</div>';

include 'base.php';
