<?php
// api/login.php
// Painel FR PLAY - API de ativação / checagem / admin
// Use HTTPS em produção. Ajuste ADMIN_KEY antes de publicar.

header('Content-Type: application/json; charset=utf-8');
date_default_timezone_set('UTC');

$dbFile = _DIR_ . '/database.json';
$ADMIN_KEY = 'troque_este_admin_key_para_producao'; // <- Mude antes de ir pra produção
$DEFAULT_M3U = 'http://vgpth.xyz/get.php?username=580383319&password=942046257&type=m3u_plus&output=mpegts';

// Helpers
function now_iso() {
    return (new DateTime('now', new DateTimeZone('UTC')))->format('c');
}
function iso_after_days($days) {
    $d = new DateTime('now', new DateTimeZone('UTC'));
    $d->modify("+{$days} days");
    return $d->format('c');
}
function iso_after_years($years) {
    $d = new DateTime('now', new DateTimeZone('UTC'));
    $d->modify("+{$years} years");
    return $d->format('c');
}
function load_db($path) {
    if (!file_exists($path)) {
        file_put_contents($path, json_encode(['devices'=>[]], JSON_PRETTY_PRINT|JSON_UNESCAPED_SLASHES));
    }
    $txt = file_get_contents($path);
    $data = json_decode($txt, true);
    if (!is_array($data)) $data = ['devices'=>[]];
    if (!isset($data['devices'])) $data['devices'] = [];
    return $data;
}
function save_db($path, $data) {
    return file_put_contents($path, json_encode($data, JSON_PRETTY_PRINT|JSON_UNESCAPED_SLASHES));
}
function normalize_mac($mac) {
    return strtoupper(trim($mac));
}

// Load DB
$db = load_db($dbFile);
$method = $_SERVER['REQUEST_METHOD'];

// ----------------- POST actions (admin) -----------------
if ($method === 'POST') {
    $action = $_POST['action'] ?? '';
    if ($action === 'activate') {
        $admin_key = $_POST['admin_key'] ?? '';
        if ($admin_key !== $ADMIN_KEY) {
            echo json_encode(['status'=>'error','message'=>'admin_key inválido']); exit;
        }
        $mac = normalize_mac($_POST['mac'] ?? '');
        $device = trim($_POST['device'] ?? '');
        $m3u = trim($_POST['m3u_url'] ?? $DEFAULT_M3U);

        if (!$mac) { echo json_encode(['status'=>'error','message'=>'mac ausente']); exit; }

        // replace or add
        $found = false;
        for ($i=0;$i<count($db['devices']);$i++){
            if (normalize_mac($db['devices'][$i]['mac']) === $mac) {
                $db['devices'][$i]['device'] = $device;
                $db['devices'][$i]['m3u_url'] = $m3u;
                $db['devices'][$i]['expire'] = iso_after_years(1);
                $db['devices'][$i]['activated_at'] = now_iso();
                $db['devices'][$i]['trial'] = false;
                $db['devices'][$i]['notes'] = 'Ativado via painel';
                $found = true;
                break;
            }
        }
        if (!$found) {
            $db['devices'][] = [
                'mac' => $mac,
                'device' => $device,
                'm3u_url' => $m3u,
                'expire' => iso_after_years(1),
                'activated_at' => now_iso(),
                'trial' => false,
                'notes' => 'Ativado via painel'
            ];
        }
        save_db($dbFile, $db);
        echo json_encode(['status'=>'ok','message'=>'Ativado 1 ano','mac'=>$mac,'expire'=>iso_after_years(1),'m3u_url'=>$m3u]);
        exit;
    }

    if ($action === 'swap_mac') {
        // Trocar MAC mantendo validade e outros dados
        $admin_key = $_POST['admin_key'] ?? '';
        if ($admin_key !== $ADMIN_KEY) { echo json_encode(['status'=>'error','message'=>'admin_key inválido']); exit; }
        $old = normalize_mac($_POST['old_mac'] ?? '');
        $new = normalize_mac($_POST['new_mac'] ?? '');
        if (!$old || !$new) { echo json_encode(['status'=>'error','message'=>'old_mac e new_mac são obrigatórios']); exit; }

        $foundIdx = null;
        for ($i=0;$i<count($db['devices']);$i++){
            if (normalize_mac($db['devices'][$i]['mac']) === $old) { $foundIdx = $i; break; }
        }
        if ($foundIdx === null) { echo json_encode(['status'=>'error','message'=>'MAC antigo não encontrado']); exit; }

        // Se já existir novo MAC, bloqueia (ou opcionalmente sobrescreve)
        for ($i=0;$i<count($db['devices']);$i++){
            if (normalize_mac($db['devices'][$i]['mac']) === $new) {
                echo json_encode(['status'=>'error','message'=>'Novo MAC já existe na base']); exit;
            }
        }

        // faz o swap mantendo campos
        $record = $db['devices'][$foundIdx];
        $record['mac'] = $new;
        $record['device'] = $record['device'] ?? '';
        $record['notes'] = ($record['notes'] ?? '') . ' | MAC trocado via painel em '.now_iso();
        // atualiza registro (substitui)
        $db['devices'][$foundIdx] = $record;
        save_db($dbFile, $db);
        echo json_encode(['status'=>'ok','message'=>'MAC trocado com sucesso','old'=>$old,'new'=>$new,'expire'=>$record['expire']]);
        exit;
    }

    if ($action === 'delete') {
        $admin_key = $_POST['admin_key'] ?? '';
        if ($admin_key !== $ADMIN_KEY) { echo json_encode(['status'=>'error','message'=>'admin_key inválido']); exit; }
        $mac = normalize_mac($_POST['mac'] ?? '');
        if (!$mac) { echo json_encode(['status'=>'error','message'=>'mac obrigatório']); exit; }
        $newArr = [];
        $deleted = false;
        foreach ($db['devices'] as $d) {
            if (normalize_mac($d['mac']) === $mac) { $deleted = true; continue;}
            $newArr[] = $d;
        }
        if ($deleted) {
            $db['devices'] = $newArr;
            save_db($dbFile, $db);
            echo json_encode(['status'=>'ok','message'=>'registro removido','mac'=>$mac]); exit;
        } else {
            echo json_encode(['status'=>'error','message'=>'mac não encontrado']); exit;
        }
    }

    if ($action === 'list') {
        $admin_key = $_POST['admin_key'] ?? '';
        if ($admin_key !== $ADMIN_KEY) { echo json_encode(['status'=>'error','message'=>'admin_key inválido']); exit; }
        echo json_encode(['status'=>'ok','devices'=>$db['devices']]);
        exit;
    }

    echo json_encode(['status'=>'error','message'=>'action POST inválida']);
    exit;
}

// ----------------- GET (app check / create trial) -----------------
$mac = normalize_mac($_GET['mac'] ?? '');
$device = trim($_GET['device'] ?? '');
if (!$mac) {
    echo json_encode(['status'=>'error','message'=>'mac obrigatório']); exit;
}

// busca
$idx = null;
for ($i=0;$i<count($db['devices']);$i++){
    if (normalize_mac($db['devices'][$i]['mac']) === $mac) { $idx = $i; break; }
}

if ($idx !== null) {
    $rec = $db['devices'][$idx];
    $expire = new DateTime($rec['expire'], new DateTimeZone('UTC'));
    $now = new DateTime('now', new DateTimeZone('UTC'));
    if ($expire >= $now) {
        // ativo
        echo json_encode([
            'status'=>'ok',
            'mac'=>$rec['mac'],
            'device'=>$rec['device'] ?? '',
            'm3u_url'=>$rec['m3u_url'] ?? $DEFAULT_M3U,
            'expire'=>$rec['expire'],
            'trial'=>$rec['trial'] ?? false
        ]);
        exit;
    } else {
        // expirado
        echo json_encode([
            'status'=>'expired',
            'mac'=>$rec['mac'],
            'device'=>$rec['device'] ?? '',
            'expire'=>$rec['expire'],
            'message'=>'assinatura expirada'
        ]);
        exit;
    }
} else {
    // cria trial de 7 dias automaticamente
    $trialExpire = iso_after_days(7);
    $rec = [
        'mac' => $mac,
        'device' => $device,
        'm3u_url' => $DEFAULT_M3U,
        'expire' => $trialExpire,
        'activated_at' => now_iso(),
        'trial' => true,
        'notes' => 'Trial criado automaticamente (7 dias)'
    ];
    $db['devices'][] = $rec;
    save_db($dbFile, $db);
    echo json_encode([
        'status'=>'trial',
        'mac'=>$rec['mac'],
        'device'=>$rec['device'],
        'm3u_url'=>$rec['m3u_url'],
        'expire'=>$rec['expire'],
        'message'=>'Trial de 7 dias criado automaticamente'
    ]);
   exit;
}