<?php
// Configuração básica
date_default_timezone_set('America/Sao_Paulo');

// Dados da sua empresa
$logo = 'https://i.imgur.com/your-logo-url.png'; // Substitua pela URL da sua logo (ou use base64 se quiser)
$nome_salao = "RAQUEL HAIR";
$slogan = "Salão do Brilho";
$telefone = "5511989217254"; // Sem +, só números
$endereco = "Av. São Remo, 45 - Vila 3";

// Tabela de preços (você pode editar aqui)
$procedimentos = [
    'Progressiva' => 230.00,
    'Selagem sem formol' => 180.00,
    'Botox' => 150.00,
    'Banho de petróleo' => 150.00,
    'Reconstrução' => 100.00,
    'Cauterização' => 100.00,
    'Hidratação & escova' => 85.00,
    'Escova & prancha' => 65.00,
    'Corte' => 25.00,
];

// Lista de agendamentos (em memória — para uso pessoal, sem banco de dados)
if (!isset($_SESSION)) session_start();
if (!isset($_SESSION['agendamentos'])) {
    $_SESSION['agendamentos'] = [];
}

// Processar novo agendamento
if ($_POST['acao'] === 'agendar') {
    $nome = trim($_POST['nome']);
    $data_hora = $_POST['data_hora'];
    $procedimento = $_POST['procedimento'];
    $desconto = floatval($_POST['desconto'] ?? 0);
    $observacoes = trim($_POST['observacoes']);

    if ($nome && $data_hora && $procedimento) {
        $valor_original = $procedimentos[$procedimento];
        $valor_final = $valor_original - $desconto;

        $_SESSION['agendamentos'][] = [
            'id' => uniqid(),
            'nome' => $nome,
            'data_hora' => $data_hora,
            'procedimento' => $procedimento,
            'valor_original' => $valor_original,
            'desconto' => $desconto,
            'valor_final' => $valor_final,
            'observacoes' => $observacoes,
            'criado_em' => date('Y-m-d H:i:s'),
        ];

        // Redireciona para evitar reenvio
        header("Location: " . $_SERVER['PHP_SELF'] . "?msg=agendado");
        exit;
    }
}

// Excluir agendamento
if ($_GET['acao'] === 'excluir' && $_GET['id']) {
    $id = $_GET['id'];
    foreach ($_SESSION['agendamentos'] as $key => $agendamento) {
        if ($agendamento['id'] === $id) {
            unset($_SESSION['agendamentos'][$key]);
            break;
        }
    }
    $_SESSION['agendamentos'] = array_values($_SESSION['agendamentos']); // Reindexa
    header("Location: " . $_SERVER['PHP_SELF'] . "?msg=excluido");
    exit;
}

// Mensagem de feedback
$msg = $_GET['msg'] ?? '';
$mensagem_feedback = '';
if ($msg === 'agendado') $mensagem_feedback = "✅ Agendamento salvo com sucesso!";
if ($msg === 'excluido') $mensagem_feedback = "🗑️ Agendamento excluído.";
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Agenda - <?= $nome_salao ?></title>
    <style>
        :root {
            --cor-fundo: #f5f0e6; /* Bege claro */
            --cor-madeira: #d2b48c; /* Tom de madeira */
            --cor-texto: #333;
            --cor-acento: #8b4513; /* Marrom escuro */
            --cor-botao: #8b4513;
            --cor-botao-hover: #6b3a0f;
            --cor-cabecalho: #fff;
            --cor-card: #fff;
            --cor-shadow: rgba(0,0,0,0.1);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        body {
            background: var(--cor-fundo);
            color: var(--cor-texto);
            line-height: 1.6;
            background-image: url('data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSI2MCIgaGVpZ2h0PSI2MCI+PHJlY3Qgd2lkdGg9IjYwIiBoZWlnaHQ9IjYwIiBmaWxsPSIjZjVmMGU2Ii8+PHBhdGggZD0iTTEwIDB2MTBoNDBoLTQwdjEwSDIwdi0xMHoiIGZpbGw9IiNkMmI0OGMiLz48L3N2Zz4=');
            background-size: 60px 60px;
        }

        .container {
            max-width: 1200px;
            margin: 20px auto;
            padding: 20px;
        }

        header {
            text-align: center;
            padding: 20px 0;
            background: linear-gradient(to right, var(--cor-madeira), #e6d5c3);
            box-shadow: 0 4px 12px var(--cor-shadow);
            border-radius: 12px;
            margin-bottom: 30px;
        }

        .logo {
            width: 180px;
            height: auto;
            margin-bottom: 15px;
            filter: drop-shadow(2px 2px 4px rgba(0,0,0,0.2));
        }

        h1 {
            font-size: 2.5rem;
            color: var(--cor-acento);
            margin-bottom: 5px;
            font-weight: 700;
        }

        .slogan {
            font-style: italic;
            color: #666;
            font-size: 1.2rem;
        }

        .info-box {
            background: var(--cor-card);
            padding: 15px;
            border-radius: 10px;
            box-shadow: 0 2px 8px var(--cor-shadow);
            margin: 20px 0;
            text-align: center;
            border-left: 5px solid var(--cor-acento);
        }

        .info-box h3 {
            color: var(--cor-acento);
            margin-bottom: 10px;
        }

        .grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
            margin-bottom: 30px;
        }

        @media (max-width: 768px) {
            .grid {
                grid-template-columns: 1fr;
            }
        }

        .card {
            background: var(--cor-card);
            padding: 20px;
            border-radius: 12px;
            box-shadow: 0 4px 12px var(--cor-shadow);
            transition: transform 0.2s;
        }

        .card:hover {
            transform: translateY(-5px);
        }

        .card h2 {
            color: var(--cor-acento);
            margin-bottom: 15px;
            border-bottom: 2px solid var(--cor-acento);
            padding-bottom: 8px;
        }

        form {
            display: flex;
            flex-direction: column;
            gap: 15px;
        }

        label {
            font-weight: 600;
            color: var(--cor-acento);
        }

        input, select, textarea {
            padding: 12px;
            border: 2px solid #ddd;
            border-radius: 8px;
            font-size: 1rem;
            transition: border-color 0.3s;
        }

        input:focus, select:focus, textarea:focus {
            outline: none;
            border-color: var(--cor-acento);
            box-shadow: 0 0 0 3px rgba(139, 69, 19, 0.1);
        }

        button {
            background: var(--cor-botao);
            color: white;
            border: none;
            padding: 12px 20px;
            border-radius: 8px;
            cursor: pointer;
            font-size: 1.1rem;
            font-weight: 600;
            transition: background 0.3s, transform 0.2s;
        }

        button:hover {
            background: var(--cor-botao-hover);
            transform: scale(1.05);
        }

        .tabela-precos {
            width: 100%;
            border-collapse: collapse;
            margin-top: 15px;
        }

        .tabela-precos th, .tabela-precos td {
            padding: 12px;
            text-align: left;
            border-bottom: 1px solid #eee;
        }

        .tabela-precos th {
            background: var(--cor-madeira);
            color: white;
            font-weight: 600;
        }

        .tabela-precos tr:last-child td {
            border-bottom: none;
        }

        .tabela-precos tr:hover {
            background: #f9f5ec;
        }

        .cronograma {
            margin-top: 20px;
        }

        .dia-semana {
            display: flex;
            justify-content: space-between;
            margin-bottom: 15px;
            padding: 10px;
            background: var(--cor-madeira);
            color: white;
            border-radius: 8px;
            font-weight: bold;
        }

        .bloco-agendamento {
            background: white;
            padding: 15px;
            margin: 10px 0;
            border-radius: 8px;
            border-left: 4px solid var(--cor-acento);
            box-shadow: 0 2px 6px var(--cor-shadow);
        }

        .bloco-agendamento h4 {
            color: var(--cor-acento);
            margin-bottom: 5px;
        }

        .bloco-agendamento p {
            margin: 5px 0;
            font-size: 0.9rem;
        }

        .btn-whatsapp {
            display: inline-block;
            background: #25D366;
            color: white;
            padding: 8px 15px;
            border-radius: 6px;
            text-decoration: none;
            font-weight: 600;
            margin-top: 10px;
            transition: background 0.3s;
        }

        .btn-whatsapp:hover {
            background: #1da85f;
        }

        .btn-excluir {
            background: #e74c3c;
            padding: 5px 10px;
            font-size: 0.8rem;
            margin-left: 10px;
        }

        .btn-excluir:hover {
            background: #c0392b;
        }

        .feedback {
            background: #d4edda;
            color: #155724;
            padding: 12px;
            border-radius: 8px;
            margin-bottom: 20px;
            text-align: center;
            border: 1px solid #c3e6cb;
        }

        footer {
            text-align: center;
            margin-top: 40px;
            padding: 20px;
            color: #666;
            font-size: 0.9rem;
        }

        .whatsapp-link {
            display: block;
            margin-top: 10px;
            font-size: 0.9rem;
            color: #25D366;
            text-decoration: underline;
        }

        .whatsapp-link:hover {
            color: #1da85f;
        }

        .alert {
            background: #fff3cd;
            color: #856404;
            padding: 12px;
            border-radius: 8px;
            margin-bottom: 20px;
            text-align: center;
            border: 1px solid #ffeaa7;
        }
    </style>
</head>
<body>

<div class="container">

    <header>
        <img src="<?= $logo ?>" alt="Logo <?= $nome_salao ?>" class="logo">
        <h1><?= $nome_salao ?></h1>
        <div class="slogan"><?= $slogan ?></div>
    </header>

    <?php if ($mensagem_feedback): ?>
        <div class="feedback"><?= $mensagem_feedback ?></div>
    <?php endif; ?>

    <div class="info-box">
        <h3>📞 Contato e Localização</h3>
        <p><strong>Telefone:</strong> (11) 98921-7254</p>
        <p><strong>Endereço:</strong> <?= $endereco ?></p>
        <p><strong>Instagram:</strong> @rhsalaodobrilho</p>
    </div>

    <div class="grid">
        <div class="card">
            <h2>📅 Agendar Cliente</h2>
            <form method="POST">
                <input type="hidden" name="acao" value="agendar">
                <label for="nome">Nome da Cliente</label>
                <input type="text" id="nome" name="nome" required placeholder="Ex: Maria Silva">

                <label for="data_hora">Data e Hora</label>
                <input type="datetime-local" id="data_hora" name="data_hora" required>

                <label for="procedimento">Procedimento</label>
                <select id="procedimento" name="procedimento" required>
                    <option value="">Selecione...</option>
                    <?php foreach ($procedimentos as $proc => $valor): ?>
                        <option value="<?= htmlspecialchars($proc) ?>"><?= htmlspecialchars($proc) ?> - R$ <?= number_format($valor, 2, ',', '.') ?></option>
                    <?php endforeach; ?>
                </select>

                <label for="desconto">Desconto (R$)</label>
                <input type="number" id="desconto" name="desconto" step="0.01" min="0" max="100" placeholder="Ex: 20.00">

                <label for="observacoes">Observações (opcional)</label>
                <textarea id="observacoes" name="observacoes" rows="3" placeholder="Ex: Cabelo muito longo, precisa de mais produto"></textarea>

                <button type="submit">✅ Agendar Cliente</button>
            </form>
        </div>

        <div class="card">
            <h2>💰 Tabela de Valores</h2>
            <p><strong>LEMBRANDO:</strong> os valores são fixos! O valor só mudará caso o cabelo for muito longo ou volumoso!!</p>
            <table class="tabela-precos">
                <thead>
                    <tr>
                        <th>Procedimento</th>
                        <th>Valor</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($procedimentos as $proc => $valor): ?>
                        <tr>
                            <td><?= htmlspecialchars($proc) ?></td>
                            <td>R$ <?= number_format($valor, 2, ',', '.') ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>

    <div class="card cronograma">
        <h2>🗓️ Cronograma da Semana</h2>

        <?php
        // Agrupar agendamentos por dia
        $agendamentos_por_dia = [];
        foreach ($_SESSION['agendamentos'] as $agendamento) {
            $data = substr($agendamento['data_hora'], 0, 10); // YYYY-MM-DD
            if (!isset($agendamentos_por_dia[$data])) {
                $agendamentos_por_dia[$data] = [];
            }
            $agendamentos_por_dia[$data][] = $agendamento;
        }

        // Ordenar por data
        ksort($agendamentos_por_dia);

        if (empty($agendamentos_por_dia)) {
            echo '<div class="alert">Nenhum agendamento para esta semana.</div>';
        } else {
            foreach ($agendamentos_por_dia as $data => $lista) {
                $data_formatada = date('d/m/Y', strtotime($data));
                echo "<div class='dia-semana'>📅 {$data_formatada}</div>";
                foreach ($lista as $agendamento) {
                    $hora = substr($agendamento['data_hora'], 11, 5);
                    $valor_final = number_format($agendamento['valor_final'], 2, ',', '.');
                    $desconto = $agendamento['desconto'] > 0 ? " (Desconto: R$ " . number_format($agendamento['desconto'], 2, ',', '.') . ")" : "";

                    $mensagem_wpp = urlencode(
                        "Olá, {$agendamento['nome']}!\n\nVocê está agendada para {$agendamento['procedimento']} às {$hora} em {$data_formatada}.\n\nValor final: R$ {$valor_final}{$desconto}\n\n{$agendamento['observacoes']}\n\nAté lá! 💖"
                    );

                    $link_wpp = "https://wa.me/{$telefone}?text={$mensagem_wpp}";

                    echo "<div class='bloco-agendamento'>";
                    echo "<h4>{$agendamento['nome']} - {$hora}</h4>";
                    echo "<p><strong>Procedimento:</strong> {$agendamento['procedimento']}</p>";
                    echo "<p><strong>Valor:</strong> R$ {$valor_final}{$desconto}</p>";
                    if ($agendamento['observacoes']) {
                        echo "<p><strong>Observações:</strong> {$agendamento['observacoes']}</p>";
                    }
                    echo "<a href='{$link_wpp}' target='_blank' class='btn-whatsapp'>📲 Enviar WhatsApp</a>";
                    echo "<a href='?acao=excluir&id={$agendamento['id']}' class='btn-excluir'>🗑️ Excluir</a>";
                    echo "</div>";
                }
            }
        }
        ?>

    </div>

</div>

<footer>
    © <?= date('Y') ?> - <?= $nome_salao ?> | Sistema de Agenda Personalizado
</footer>

</body>
</html>