<?php
header('Content-Type: application/json; charset=utf-8');
$base = dirname(__FILE__);
$config_path = $base . '/config.php';
if (!file_exists($config_path)) {
    http_response_code(500);
    echo json_encode(['status'=>'error','message'=>'Config missing']);
    exit;
}
require_once $config_path;

try {
    $pdo = getPDO();
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['status'=>'error','message'=>'DB connection failed']);
    exit;
}

$user = $_GET['user'] ?? $_POST['user'] ?? null;
$pass = $_GET['pass'] ?? $_POST['pass'] ?? null;

if (!$user || !$pass) {
    echo json_encode(['status'=>'error','message'=>'Missing credentials']);
    exit;
}

$stmt = $pdo->prepare('SELECT * FROM users WHERE username = ? LIMIT 1');
$stmt->execute([$user]);
$row = $stmt->fetch();
if (!$row) {
    echo json_encode(['status'=>'error','message'=>'User not found']);
    exit;
}
if (!password_verify($pass, $row['password'])) {
    echo json_encode(['status'=>'error','message'=>'Invalid password']);
    exit;
}
// success
echo json_encode(['status'=>'ok','m3u_url'=>$row['m3u_url'] ?? null, 'user'=>$row['username']]);
?>