<?php
header('Content-Type: application/json; charset=utf-8');
$base = dirname(__FILE__);
$config_path = $base . '/config.php';
if (!file_exists($config_path)) {
    http_response_code(500);
    echo json_encode(['status'=>'error','message'=>'Config missing']);
    exit;
}
require_once $config_path;
require_once 'helpers.php';

// expected params: mac or device_id or user/pass
$mac = $_GET['mac'] ?? $_GET['device_id'] ?? null;
$user = $_GET['user'] ?? null;
$pass = $_GET['pass'] ?? null;

$pdo = getPDO();

if ($mac) {
    $stmt = $pdo->prepare('SELECT * FROM devices WHERE device_id = ? OR mac = ? LIMIT 1');
    $stmt->execute([$mac, $mac]);
    $device = $stmt->fetch();
    if (!$device) {
        echo json_encode(['status'=>'error','message'=>'Device not found']);
        exit;
    }
    // check subscription or trial
    $now = time();
    $expires = $device['expires'] ?? null;
    if ($expires && $now > strtotime($expires)) {
        echo json_encode(['status'=>'expired','message'=>'Subscription expired']);
        exit;
    }
    // return m3u
    $m3u = $device['m3u_url'] ?? null;
    echo json_encode(['status'=>'ok','m3u_url'=>$m3u,'expires'=>$expires]);
    exit;
} elseif ($user && $pass) {
    $stmt = $pdo->prepare('SELECT * FROM users WHERE username = ? LIMIT 1');
    $stmt->execute([$user]);
    $u = $stmt->fetch();
    if (!$u || !password_verify($pass, $u['password'])) {
        echo json_encode(['status'=>'error','message'=>'Invalid credentials']);
        exit;
    }
    echo json_encode(['status'=>'ok','m3u_url'=>$u['m3u_url'] ?? null]);
    exit;
} else {
    echo json_encode(['status'=>'error','message'=>'Missing parameters']);
    exit;
}
?>